function changeArrow( id ) {
    var obj = document.getElementById(id);
    if( obj != null ) {
        if( obj.innerHTML == '4' ) {
            obj.innerHTML = '6';
        } else {
            obj.innerHTML = '4';
        }
    }
}

function changeArrowAlerts( id ) {
    var objArrow = document.getElementById(id);
    if( objArrow ) {
        var loc = objArrow.src;
        var idxLastSlash = loc.lastIndexOf("/");
        var imgDir = loc.substring(0, idxLastSlash+1);
        var currentImg = loc.substring(idxLastSlash+1, loc.length);
        var arrImgParts = currentImg.split("_");
        var currentImgPrefix = arrImgParts[0];
        var currentArrowState =arrImgParts[1];
        var currentImgSuffix = arrImgParts[2];

        if( currentArrowState == "down" ) {
            objArrow.src = imgDir + currentImgPrefix + "_right_" + currentImgSuffix;
        } else {
            objArrow.src = imgDir + currentImgPrefix + "_down_" + currentImgSuffix;   
        }
    }
}

function showHide( id ) {
    var obj = document.getElementById(id);
    var state = "";

    updateSessionInfo();
    if( obj != null ) {
        if( obj.style.display == "" ) {
            state = 'none';
        } else {
            state = '';
        }
        obj.style.display = state;
        // cookies require value
        if( state == "" ) {
            state = 'block';
        }
        //setCookie(id, state);
    }
    //alert(obj);
    //changeArrow( "arrow_" + id );
}

function showHideFromCookie( id, stateFromCookie ) {
    var obj = document.getElementById(id);
    var state = stateFromCookie;
    // block has a weird effect in Firefox where it leaves residual space when
    // collapsing back, does not happen when alerts are popping up before the 
    // collapse
    if( stateFromCookie == "block" ) {
        state = "";
    }
    if( obj != null ) {
        obj.style.display = state;
        var objArrow = document.getElementById("arrow_" + id);
        var objImg = document.getElementById("img_" + id);
        if( objArrow ) {
            var loc = objArrow.src;
            var idxLastSlash = loc.lastIndexOf("/");
            var imgDir = loc.substring(0, idxLastSlash+1);
            var currentImg = loc.substring(idxLastSlash+1, loc.length);
            var idxCurrentImgLastUnderscore = currentImg.lastIndexOf("_");
            var currentImgPrefix = currentImg.substring(0, idxCurrentImgLastUnderscore);

            if( state == "" ) {
                objArrow.src = imgDir + currentImgPrefix + "_down.gif";
            } else {
                objArrow.src = imgDir + currentImgPrefix + "_right.gif";    
            }
        }
        if( objImg ) {
            var loc = objImg.src;
            var idxLastSlash = loc.lastIndexOf("/");
            var imgDir = loc.substring(0, idxLastSlash+1);
            var currentImg = loc.substring(idxLastSlash+1, loc.length);
            var idxCurrentImgUnderscore = currentImg.indexOf("_");
            var currentImgStatus = currentImg.substring(0, idxCurrentImgUnderscore);
            if( state == "" ) {
                objImg.src = imgDir + currentImgStatus + "_32x32.gif";
            } else {
                objImg.src = imgDir + currentImgStatus + "_32x20.gif";    
            }
        }
    }
}

function showHideGroup( id ) {
    var obj = document.getElementById("group" + id);
    var state = "";
    
    updateSessionInfo();
    if( obj != null ) {
        if( obj.style.display == "" ) {
            state = 'none';
        } else {
            state = '';
        }
        obj.style.display = state;
    }
    changeArrow( "groupArrow" + id );
}

function regroup( formObj ) {
    var selIdx = formObj.group.selectedIndex;
    var val = formObj.group.options[selIdx].value;
    //alert(val);
}

function setAction( formEle ) {
    var formObj = formEle.form;
    //alert(formEle.value);
    formObj.realAction.value = formEle.value;
    return submitForm(formObj);
    //formObj.submit();
}

function doRefresh( contentPageOnly ) {
    var contentFrameUrl = window.frames['content'].location.toString();
    var uri = contentFrameUrl;
    var queryStringIdx = contentFrameUrl.indexOf("?");
    var queryString = "";
    var bFoundTabId = false;
    var arrParameters;
    if( queryStringIdx > -1 ) {
        uri = contentFrameUrl.substring(0,queryStringIdx);

        queryString = contentFrameUrl.substring(queryStringIdx+1, contentFrameUrl.length);
        arrParameters = queryString.split("&");
        // replace the tabId
        for( var i=0; i<arrParameters.length; i++ ) {
            if( arrParameters[i].indexOf("tabId=") == 0 ) {
                arrParameters[i] = "tabId=" + top.currentTabId;
                bFoundTabId = true;
            }
        }
        if( !bFoundTabId ) {
            arrParameters[arrParameters.length] = "tabId=" + top.currentTabId;
        }
        // reconstruct queryString after intervention
        queryString = arrParameters.join("&");
    }
    window.frames['content'].location = uri + "?" + queryString;
    if( contentPageOnly == null || !contentPageOnly ) {
        window.frames['nav'].location = window.frames['nav'].location.toString();
    }
}

function submitForm( formObj ) {
    var actionUrl = formObj.action;
    var uri = actionUrl;
    var queryStringIdx = actionUrl.indexOf("?");
    var queryString = "";
    var bFoundTabId = false;
    var arrParameters;
    if( queryStringIdx > -1 ) {
        uri = actionUrl.substring(0,queryStringIdx);

        queryString = actionUrl.substring(queryStringIdx+1, actionUrl.length);
        arrParameters = queryString.split("&");
        // replace the tabId
        for( var i=0; i<arrParameters.length; i++ ) {
            if( arrParameters[i].indexOf("tabId=") == 0 ) {
                arrParameters[i] = "tabId=" + top.currentTabId;
                bFoundTabId = true;
            }
        }
        if( !bFoundTabId ) {
            arrParameters[arrParameters.length] = "tabId=" + top.currentTabId;
        }
        // reconstruct queryString after intervention
        queryString = arrParameters.join("&");
    }
    formObj.action = uri + "?" + queryString;
    formObj.submit();
    return false;
}

// make sure the login page is the top frame
function frameCheck() {
    if( opener != null ) {
        // don't use alerts on close(), it will stop it from closing
        self.close();
        // refresh the opener to have user login from there
        opener.history.go();
    } else if( top != self ) {
        top.location = self.location.toString();
        //alert(self.location.toString());
    }
}

function firstFocus() {
   // Indicates which form and element to focus on
   var foundForm = -1, foundElement = -1;
   var done = false;

   // Loop through all the forms on the pages
   var f = 0;
   while( f<document.forms.length && !done ) {
      // Loop through all the elements in the form
      var e = 0;
      while(e<document.forms[f].elements.length && !done)
      {
         if( document.forms[f].elements[e].type == 'text' ||
            document.forms[f].elements[e].type == 'password' ||
            document.forms[f].elements[e].type == 'textarea' ) {
            done = true;
            foundForm = f;
            foundElement = e;
         }
         e++;
      } // while elements
      f++;
   } // while forms

   // Only set focus if there is a legitimate form & element
   if( foundForm != -1 && foundElement != -1 ) {
      document.forms[foundForm].elements[foundElement].focus();
   }
}


function swapImage( id, imgSrc1, imgSrc2 ) {
    var img = document.getElementById(id);
    var loc = img.src;
    var idxLastSlash = loc.lastIndexOf("/");
    var imgDir = loc.substring(0, idxLastSlash+1);
    var currentImg = loc.substring(idxLastSlash+1, loc.length)
    if( currentImg == imgSrc1 ) {
        img.src = imgDir + imgSrc2;
    } else {
        img.src = imgDir + imgSrc1;
    }
}

function hexnib(d) {
    if( d < 10 ) {
        return d; 
    } else {
        return String.fromCharCode(65+d-10);
    }
}

function hexbyte(d) {
    return "%" + hexnib((d&240)>>4) + "" + hexnib(d&15);
}

function hexcode( str ) {
    var result="";
    var hex="";
    for( var i=0; i<str.length; i++ ) {
        var cc = str.charCodeAt(i);
        if( cc<128 ) {
            result+=hexbyte(cc);
        } else if((cc>127) && (cc<2048)) {
            result+=  hexbyte((cc>>6)|192)
                + hexbyte((cc&63)|128);
        } else {
            result+=  hexbyte((cc>>12)|224)
                + hexbyte(((cc>>6)&63)|128)
                + hexbyte((cc&63)|128);
        }
    }
    return result;
}

String.prototype.trim = function() {
    return this.replace(/^\s*/,"").replace(/\s*$/,"");
}

function setAppRoot( root ) {
    top.appRoot = root;
}

function getAppRoot() {
    return top.appRoot;
}

function getXYcoord ( imgName ) {
    var elm = document.images[imgName];
    // NS4 images contain x and y values   
    if ( document.layers ) {
        return elm;
    }
    
    var coordObj = { x:0 ,y:0 };
    do {
        coordObj.x += parseInt( elm.offsetLeft );
        coordObj.y += parseInt( elm.offsetTop );
        elm = elm.offsetParent;
    }
    while ( elm );
    return coordObj;
}

/**** Cookies ****/
function setCookie( targetName, value ) {
    //alert(targetName + " = " + value);
    //var cookieValue = targetName + "=" + escape(value);
    //var exp = new Date();
    //var nowPlus90Days = exp.getTime() + (90 * 24 * 60 * 60 * 1000);
    //exp.setTime( nowPlus90Days );
    //document.cookie = cookieValue + "; expires=" + exp.toGMTString() + ";";
}

function restoreTreeState() {
    var thisCookie = document.cookie.split("; ")
    var name = "";
    var value = "";
    for( i=0; i<thisCookie.length; i++ ) {
        name = thisCookie[i].split("=")[0];
        value = unescape(thisCookie[i].split("=")[1]);
        showHideFromCookie(name, value);
    }
}

function getCookieValue( name ) {
    var thisCookie = document.cookie.split("; ")
    for( i=0; i<thisCookie.length; i++ ) {
        if( name == thisCookie[i].split("=")[0] ) {
            return unescape(thisCookie[i].split("=")[1]);
       }
    }
    return null;
}

function clearTreeState() {
    var thisCookie = document.cookie.split("; ")
    var name = "";
    for( i=0; i<thisCookie.length; i++ ) {
        name = thisCookie[i].split("=")[0];
        if( name.indexOf("jsessionid") != 0 ) { // don't clear the sessionid
            document.cookie = name + "=; expires=Thu, 01-Jan-1970 00:00:00 GMT;";
        }
    }
}

function setLoadText( str ) {
    var obj = document.getElementById("loadText");
    obj.innerHTML = str;
}


function browserCheck( msg ) {
    var userAgent = navigator.userAgent.toLowerCase();
    var result = false;
    var idxIe = userAgent.indexOf("msie");
    var idxFirefox = userAgent.indexOf("firefox");

    if( idxIe != -1 ){
        // we are at least IE
        
        idxSemi = userAgent.indexOf(";",idxIe);
        substring = userAgent.substring(idxIe,idxSemi);
        
        if(substring.indexOf(" 6.") != -1){
        // we are version 6
            result = true;
        }
    } else if( idxFirefox != -1 ) {
        result = true;
    }
    if( !result ){
        alert(msg);
    }
}

function createOption( oSel, newValue, newText, isSelected ) {
    //alert(newText + ' ' + isSelected);
    var oOption = document.createElement("option");
    oOption.value = newValue;
    oOption.text = newText;
    oSel.add(oOption);
    if( isSelected ) {
        oSel.options[oSel.length-1].selected=true;
    }
}


function deleteOption( oSel, idx ) {
    if( oSel.options.length != 0 ) { 
        oSel.options[idx] = null;
    }
}

function deleteAllOptions( oSel ) {
    var optionCount = oSel.options.length;
    // delete from the bottom up to avoid misplaced index
    if( optionCount != 0 ) { 
        for( var i=optionCount-1; i>-1; i-- ) {
            deleteOption(oSel, i);
        }
    }
}

function goTo( url ) {
    self.location = url;
}