<xsl:stylesheet
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:output encoding="UTF-8"/>

    <!-- Attribute reference doesn't work for some reason
    <xsl:variable name="agentError" select="/ManagedSystems/AgentError/@label" />
    -->
    <xsl:variable name="AgentError" select="/ManagedSystems/Labels/AgentError" />
    <xsl:variable name="Total" select="/ManagedSystems/Labels/Total" />
    <xsl:variable name="MachineName" select="/ManagedSystems/Labels/MachineName" />
    <xsl:variable name="State" select="/ManagedSystems/Labels/State" />
    <xsl:variable name="IP" select="/ManagedSystems/Labels/IP" />
    <xsl:variable name="Location" select="/ManagedSystems/Labels/Location" />
    <xsl:variable name="OSVersion" select="/ManagedSystems/Labels/OSVersion" />
    <xsl:variable name="OSRevision" select="/ManagedSystems/Labels/OSRevision" />
    <xsl:variable name="OSSPLevel" select="/ManagedSystems/Labels/OSSPLevel" />
    <xsl:variable name="CPUType" select="/ManagedSystems/Labels/CPUType" />
    <xsl:variable name="CPUNum" select="/ManagedSystems/Labels/CPUNum" />
    <xsl:variable name="Function" select="/ManagedSystems/Labels/Function" />
    <xsl:variable name="AssetNumber" select="/ManagedSystems/Labels/AssetNumber" />
    <xsl:variable name="AssetValue" select="/ManagedSystems/Labels/AssetValue" />
    <xsl:variable name="AssetDate" select="/ManagedSystems/Labels/AssetDate" />

    <xsl:variable name="Owner" select="/ManagedSystems/Labels/Owner" />
    <xsl:variable name="MachineModel" select="/ManagedSystems/Labels/MachineModel" />
    <xsl:variable name="Manufacturer" select="/ManagedSystems/Labels/Manufacturer" />    
    
    <xsl:variable name="BoardLabel" select="/ManagedSystems/Labels/BoardLabel" />
    <xsl:variable name="BoardManufacturer" select="/ManagedSystems/Labels/BoardManufacturer" />
    <xsl:variable name="BoardModel" select="/ManagedSystems/Labels/BoardModel" />
    <xsl:variable name="SensorInfo" select="/ManagedSystems/Labels/SensorInfo" />
    <xsl:variable name="NumMemBanks" select="/ManagedSystems/Labels/NumMemBanks" />
    
    <xsl:variable name="MemoryLabel" select="/ManagedSystems/Labels/MemoryLabel" />
    <xsl:variable name="MemoryPhysicalLabel" select="/ManagedSystems/Labels/MemoryPhysicalLabel" />
    <xsl:variable name="MemoryPhysicalUse" select="/ManagedSystems/Labels/MemoryPhysicalUse" />
    <xsl:variable name="MemoryVirtualLabel" select="/ManagedSystems/Labels/MemoryVirtualLabel" />
    <xsl:variable name="MemoryVirtualTotal" select="/ManagedSystems/Labels/MemoryVirtualTotal" />
    <xsl:variable name="MemoryVirtualUse" select="/ManagedSystems/Labels/MemoryVirtualUse" />
    <xsl:variable name="MemoryBank" select="/ManagedSystems/Labels/MemoryBank" />
    <xsl:variable name="MemoryBankLabel" select="/ManagedSystems/Labels/MemoryBankLabel" />    
    <xsl:variable name="MemoryCapacity" select="/ManagedSystems/Labels/MemoryCapacity" />
    <xsl:variable name="MemoryCapacityTotal" select="/ManagedSystems/Labels/MemoryCapacityTotal" />
    <xsl:variable name="VirtualMem" select="/ManagedSystems/Labels/VirtualMem" />
    
    <xsl:variable name="DisplayLabel" select="/ManagedSystems/Labels/DisplayLabel" />
    <xsl:variable name="DisplayModel" select="/ManagedSystems/Labels/DisplayModel" />
    <xsl:variable name="DisplayMemory" select="/ManagedSystems/Labels/DisplayMemory" />
    <xsl:variable name="MonitorName" select="/ManagedSystems/Labels/MonitorName" />
    <xsl:variable name="MonitorSerial" select="/ManagedSystems/Labels/MonitorSerial" />

    <xsl:variable name="Slots" select="/ManagedSystems/Labels/Slots" />
    <xsl:variable name="SlotName" select="/ManagedSystems/Labels/SlotName" />
    <xsl:variable name="SlotStatus" select="/ManagedSystems/Labels/SlotStatus" />
    
    <xsl:variable name="PhysicalDisks" select="/ManagedSystems/Labels/PhysicalDisks" />
    <xsl:variable name="PhysicalDiskDeviceID" select="/ManagedSystems/Labels/PhysicalDiskDeviceID" />
    <xsl:variable name="PhysicalDiskTotalSize" select="/ManagedSystems/Labels/PhysicalDiskTotalSize" />
    <xsl:variable name="PhysicalDiskInfo" select="/ManagedSystems/Labels/PhysicalDiskInfo" />
    <xsl:variable name="NumLogicalDisks" select="/ManagedSystems/Labels/NumLogicalDisks" />        
    
    <xsl:variable name="LogicalDisks" select="/ManagedSystems/Labels/LogicalDisks" />
    <xsl:variable name="LogicalDiskName" select="/ManagedSystems/Labels/LogicalDiskName" />
    <xsl:variable name="LogicalDiskFreeSpace" select="/ManagedSystems/Labels/LogicalDiskFreeSpace" />
    <xsl:variable name="LogicalDiskTotalSize" select="/ManagedSystems/Labels/LogicalDiskTotalSize" />
    
    <xsl:variable name="NetworkInformationLabel" select="/ManagedSystems/Labels/NetworkInformationLabel" />
    <xsl:variable name="NetworkAdapterLabel" select="/ManagedSystems/Labels/NetworkAdapterLabel" />
    <xsl:variable name="NetworkDHCPLabel" select="/ManagedSystems/Labels/NetworkDHCPLabel" />
    <xsl:variable name="NetworkIPLabel" select="/ManagedSystems/Labels/NetworkIPLabel" />
    <xsl:variable name="NetworkMACLabel" select="/ManagedSystems/Labels/NetworkMACLabel" />
    
    <xsl:variable name="RemovableDeviceLabel" select="/ManagedSystems/Labels/RemovableDeviceLabel" />
    <xsl:variable name="RemovableDeviceName" select="/ManagedSystems/Labels/RemovableDeviceName" />
    <xsl:variable name="RemovableDeviceDescription" select="/ManagedSystems/Labels/RemovableDeviceDescription" />
    
    <xsl:variable name="DiskCapacityTotal" select="/ManagedSystems/Labels/DiskCapacityTotal" />
    <xsl:variable name="RaidLabel" select="/ManagedSystems/Labels/RaidLabel" />
    <xsl:variable name="RaidControllerModel" select="/ManagedSystems/Labels/RaidControllerModel" />
    <xsl:variable name="RaidController" select="/ManagedSystems/Labels/RaidController" />
    <xsl:variable name="RaidSet" select="/ManagedSystems/Labels/RaidSet" />
    <xsl:variable name="RaidStatus" select="/ManagedSystems/Labels/RaidStatus" />
    <xsl:variable name="RaidLevel" select="/ManagedSystems/Labels/RaidLevel" />
    <xsl:variable name="RaidSize" select="/ManagedSystems/Labels/RaidSize" />
    <xsl:variable name="RaidNumDrives" select="/ManagedSystems/Labels/RaidNumDrives" />
    
    <xsl:variable name="Applications" select="/ManagedSystems/Labels/Applications" />
    <xsl:variable name="ApplicationName" select="/ManagedSystems/Labels/ApplicationName" />
    <xsl:variable name="ApplicationVendor" select="/ManagedSystems/Labels/ApplicationVendor" />
    <xsl:variable name="ApplicationVersion" select="/ManagedSystems/Labels/ApplicationVersion" />
    <xsl:variable name="ApplicationCount" select="/ManagedSystems/Labels/ApplicationCount" />

    <xsl:template match="/ManagedSystems">

      <table border="0"  cellpadding="0" cellspacing="0" width="570px">
          <xsl:apply-templates/>
           <!-- Process Inventory -->
      </table>

   </xsl:template>
    <!-- Don't output Labels for anything -->
    <xsl:template match="/ManagedSystems/Labels" />

   <xsl:template match="/ManagedSystems/ManagedSystem">
    <tr>
        <td colspan="2" bgcolor="black" style='font-size:12px; padding-left:5px'><font color="white"><xsl:copy-of select="$MachineName"/>: <xsl:value-of select="Name"/> | <xsl:copy-of select="$State"/>: <xsl:value-of select="State"/></font></td>
    </tr>
    <tr>
        <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$IP"/></td>
        <td width="285px" style='font-size:12px; padding-left:5px'><xsl:value-of select="IP"/></td>
    </tr>
    
    <xsl:if test="count(SummaryEmpty) &gt; 0">
      <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$OSVersion"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$OSRevision"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$OSSPLevel"/></td>
	      <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
    	  <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Location"/></td>
	      <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    	</tr>
    	<tr>
    		<td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Function"/></td>
	      <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    	</tr>
      <tr>
          <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$AssetNumber"/></td>
          <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
          <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$AssetValue"/></td>
          <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
          <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$AssetDate"/></td>
          <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
          <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Owner"/></td>
          <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
          <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$MachineModel"/></td>
          <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
          <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Manufacturer"/></td>
          <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
        
    </xsl:if>
    <xsl:for-each select="Summary">
      <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$OSVersion"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="OSVersion"/></td>
      </tr>
      <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$OSRevision"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="OSRevision"/></td>
      </tr>
      <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$OSSPLevel"/></td>
	      <td style='font-size:12px; padding-left:5px'><xsl:value-of select="OSSPLevel"/></td>
      </tr>
    	<tr>
    		<td class='detailSection alignLeft'><xsl:copy-of select="$Location"/></td>
	      <td style='font-size:12px; padding-left:5px'><xsl:value-of select="Location"/></td>
	    </tr>
    	<tr>
    		<td class='detailSection alignLeft'><xsl:copy-of select="$Function"/></td>
	      <td style='font-size:12px; padding-left:5px'><xsl:value-of select="Function"/></td>
    	</tr>
      <tr>
          <td class='detailSection alignLeft'><xsl:copy-of select="$AssetNumber"/></td>
          <td style='font-size:12px; padding-left:5px'><xsl:value-of select="AssetNumber"/></td>
      </tr>
      <tr>
          <td class='detailSection alignLeft'><xsl:copy-of select="$AssetValue"/></td>
          <td style='font-size:12px; padding-left:5px'><xsl:value-of select="AssetValue"/></td>
      </tr>
      <tr>
          <td class='detailSection alignLeft'><xsl:copy-of select="$AssetDate"/></td>
          <td style='font-size:12px; padding-left:5px'><xsl:value-of select="AssetDate"/></td>
      </tr>
      <tr>
          <td class='detailSection alignLeft'><xsl:copy-of select="$Owner"/></td>
          <td style='font-size:12px; padding-left:5px;'><xsl:value-of select="Owner"/></td>
      </tr>
      <tr>       
          <td class='detailSection alignLeft'><xsl:copy-of select="$MachineModel"/></td>
          <td style='font-size:12px; padding-left:5px'><xsl:value-of select="MachineModel"/></td>
      </tr>
      <tr>
          <td class='detailSection alignLeft'><xsl:copy-of select="$Manufacturer"/></td>
          <td style='font-size:12px; padding-left:5px'><xsl:value-of select="Manufacturer"/></td>
      </tr>
    </xsl:for-each>
    <xsl:if test="count(DetailsEmpty) &gt; 0">
      <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$OSVersion"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$OSRevision"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
      <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$OSSPLevel"/></td>
	      <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
      </tr>
    	<tr>
    		<td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Location"/></td>
	      <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    	</tr>
    	<tr>
    		<td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Function"/></td>
	        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    	</tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$AssetNumber"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$AssetValue"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$AssetDate"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Owner"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$MachineModel"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Manufacturer"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    <xsl:for-each select="Details">
      <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$OSVersion"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="OSVersion"/></td>
      </tr>
      <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$OSRevision"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="OSRevision"/></td>
      </tr>
      <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$OSSPLevel"/></td>
	      <td style='font-size:12px; padding-left:5px'><xsl:value-of select="OSSPLevel"/></td>
      </tr>
    	<tr>
    		<td class='detailSection alignLeft'><xsl:copy-of select="$Location"/></td>
	      <td style='font-size:12px; padding-left:5px'><xsl:value-of select="Location"/></td>
	    </tr>
    	<tr>
    		<td class='detailSection alignLeft'><xsl:copy-of select="$Function"/></td>
	        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="Function"/></td>
    	</tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$AssetNumber"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="AssetNumber"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$AssetValue"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="AssetValue"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$AssetDate"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="AssetDate"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$Owner"/></td>
            <td style='font-size:12px; padding-left:5px;'><xsl:value-of select="Owner"/></td>
        </tr>
        <tr>       
            <td class='detailSection alignLeft'><xsl:copy-of select="$MachineModel"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="MachineModel"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$Manufacturer"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="Manufacturer"/></td>
        </tr>
    </xsl:for-each>            
    

    <!-- /////////////////////////// Section for summary only fields /////////////////////////// -->
    <xsl:if test="count(SummaryEmpty) &gt; 0">
    <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$CPUNum"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$CPUType"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$NumMemBanks"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$MemoryCapacityTotal"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$NumLogicalDisks"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$DiskCapacityTotal"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    </tr>    
    <tr>        
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$RaidControllerModel"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    </tr>    
    <tr>        
        <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Applications"/></td>
        <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
    </tr> 
    </xsl:if>
    <xsl:for-each select="Summary">
    <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$CPUNum"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="CPUNum"/></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$CPUType"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="CPUType"/></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$NumMemBanks"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="NumMemBanks"/></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$MemoryPhysicalLabel"/></td>
        <td  style='font-size:12px; padding-left:5px'><xsl:value-of select="MemSize"/></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$VirtualMem"/></td>
        <td  style='font-size:12px; padding-left:5px'><xsl:value-of select="VirtualMem"/></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$NumLogicalDisks"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="NumLogicalDisks"/></td>
    </tr>
    <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$DiskCapacityTotal"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="DiskCapacity"/></td>
    </tr>
    
    <xsl:if test="(RaidControllerModel != 'null') and (RaidControllerModel != '')">
    <tr>        
          <td class='detailSection alignLeft'><xsl:copy-of select="$RaidControllerModel"/></td>
          <td style='font-size:12px; padding-left:5px'><xsl:value-of select="RaidControllerModel"/></td>        
    </tr>
    </xsl:if>
    
    <tr>
        <td class='detailSection alignLeft'><xsl:copy-of select="$Applications"/></td>
        <td style='font-size:12px; padding-left:5px'><xsl:value-of select="ApplicationCount"/></td>
    </tr>
    </xsl:for-each>


    <!-- /////////////////////////// Section for detailed reports /////////////////////////// -->
    
    <xsl:if test="count(DetailsEmpty) &gt; 0">
        <!-- Board Information -->    
        <tr>
            <td class="hortline" colspan="2" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$BoardLabel"/></td>            
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$CPUNum"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$CPUType"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$BoardModel"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$BoardManufacturer"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$SensorInfo"/></td>
            <td style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    <xsl:for-each select="Details">
        <!-- Board Information -->    
        <tr>
            <td class="hortline" colspan="2" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$BoardLabel"/></td>            
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$CPUNum"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="CPUNum"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$CPUType"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="CPUType"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$BoardModel"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="BoardModel"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$BoardManufacturer"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="BoardManufacturer"/></td>
        </tr>
        <tr>
            <td class='detailSection alignLeft'><xsl:copy-of select="$SensorInfo"/></td>
            <td style='font-size:12px; padding-left:5px'><xsl:value-of select="SensorInfo"/></td>
        </tr>
    </xsl:for-each>   
    
    <!-- Display -->
    <xsl:apply-templates select="Display"/>
    <xsl:if test="count(DetailsEmpty) &gt; 0">
        <tr>
            <td class="hortline" colspan="2" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$DisplayLabel"/></td>
        </tr>
        <tr>
            <td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
       
    <!-- Physical Memory -->
    <xsl:apply-templates select="MemoryPhysical"/>
    <xsl:if test="count(DetailsEmpty) &gt; 0">
        <tr>
            <td class="hortline" colspan="2" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$MemoryPhysicalLabel"/></td>
        </tr>
        <tr>
            <td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    <!-- Virtual Memory -->
    <xsl:apply-templates select="MemoryVirtual"/>
    <xsl:if test="count(DetailsEmpty) &gt; 0">
        <tr>
            <td class="hortline" colspan="2" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$MemoryVirtualLabel"/></td>
        </tr>
        <tr>
            <td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    <!-- Physical Disks -->
    <xsl:apply-templates select="PhysicalDisks"/>
    <xsl:if test="(count(DetailsEmpty) &gt; 0) or (count(EmptyPhysicalDisks) &gt; 0)">
        <tr>
            <td class="hortline" colspan="2" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$PhysicalDisks"/>Physical Disks</td>
        </tr>
        <tr>
            <td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    <!-- RAID Controllers -->
    <xsl:apply-templates select="RaidControllers"/>
    <xsl:if test="(count(DetailsEmpty) &gt; 0) or (count(EmptyPhysicalDisks) &gt; 0)">
        <tr>
            <td class="hortline" colspan="2" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$RaidLabel"/>Physical Disks</td>
        </tr>
        <tr>
            <td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    <!-- Logical Disks -->
    <xsl:apply-templates select="LogicalDisks"/>
    <xsl:if test="(count(DetailsEmpty) &gt; 0) or (count(EmptyLogicalDisks) &gt; 0)">
        <tr>
            <td class="hortline" colspan="4" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$LogicalDisks"/></td>
        </tr>
        <tr>
            <td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    <!-- Removable Devices -->
    <xsl:apply-templates select="RemovableDevices"/>
    <xsl:if test="(count(DetailsEmpty) &gt; 0) or (count(EmptyLogicalDisks) &gt; 0)">
        <tr>
            <td class="hortline" colspan="4" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$RemovableDeviceLabel"/></td>
        </tr>
        <tr>
            <td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    <!-- Network Adapters -->
    <xsl:apply-templates select="NetworkAdapters"/>
    <xsl:if test="(count(DetailsEmpty) &gt; 0) or (count(EmptyLogicalDisks) &gt; 0)">
        <tr>
            <td class="hortline" colspan="4" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$NetworkInformationLabel"/></td>
        </tr>
        <tr>
            <td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    <!-- PCI Slots -->
    <xsl:apply-templates select="PCISlots"/>
    <xsl:if test="count(DetailsEmpty) &gt; 0">
        <tr>
            <td class="hortline" colspan="2" ><img src="../images/clear.gif"/></td>
        </tr>
        <tr>
            <td width="285px"  colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Slots"/></td>
        </tr>
        <tr>
            <td width="285px"  colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
        </tr>
    </xsl:if>
    
    <xsl:apply-templates select="IPs"/>

	<!-- Installed applications -->
	<xsl:apply-templates select="Applicatons"/>
    <xsl:if test="count(DetailsEmpty) &gt; 0">
			<tr>
				<td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Applications"/></td>
			</tr>
			<tr>
				<td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
			</tr>
	</xsl:if>
    <!-- /// End section for details /// -->

</xsl:template>

<xsl:template match="Display">
    <tr>
        <td class="hortline" colspan="2"><img src="../images/clear.gif"/></td>
    </tr>
    <tr>
        <td colspan="2" class='detailSection alignLeft'><xsl:copy-of select="$DisplayLabel"/></td>
    </tr>
    <tr>
        <td colspan="2">
            <table border="0"  cellpadding="0" cellspacing="0">
            <tr>
                <td width="190" class='detailSection alignLeft'><xsl:copy-of select="$DisplayModel"/></td>
                <td width="190" class='detailSection alignLeft'><xsl:copy-of select="$DisplayMemory"/></td>                
            </tr>            
            <tr>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:value-of select="DisplayModel"/></td>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:value-of select="DisplayMemory"/></td>             
            </tr>            
            <tr>
                <td width="190" class='detailSection alignLeft'><xsl:copy-of select="$MonitorName"/></td>
                <td width="190" class='detailSection alignLeft'><xsl:copy-of select="$MonitorSerial"/></td>
            </tr>
            <tr>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:value-of select="MonitorName"/></td>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:value-of select="MonitorSerial"/></td>
            </tr>
            </table>
        </td>
    </tr>
</xsl:template>


<xsl:template match="LogicalDisks">
    <tr>
        <td class="hortline" colspan="2"><img src="../images/clear.gif"/></td>
    </tr>
    <tr>
        <td colspan="2" class='detailSection alignLeft'><xsl:copy-of select="$LogicalDisks"/></td>
    </tr>
    <tr>
        <td colspan="2">
            <table border="0"  cellpadding="0" cellspacing="0">
            <tr>
                <td width="190" class='detailSection alignLeft'><xsl:copy-of select="$LogicalDiskName"/></td>
                <td width="190" class='detailSection alignLeft'><xsl:copy-of select="$LogicalDiskFreeSpace"/></td>
                <td width="190" class='detailSection alignLeft'><xsl:copy-of select="$LogicalDiskTotalSize"/></td>
            </tr>
            <xsl:for-each select="LogicalDisk">
            <tr>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:value-of select="DeviceId"/></td>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:value-of select="Available"/></td>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:value-of select="Capacity"/></td>
            </tr>
            </xsl:for-each>
            <tr>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:copy-of select="$Total"/></td>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:value-of select="TotalAvail"/></td>
                <td width="190" style='font-size:12px; padding-left:5px'><xsl:value-of select="TotalCap"/></td>
            </tr>
            </table>
        </td>
    </tr>
</xsl:template>

<xsl:template match="NetworkAdapters">
    <tr>
        <td class="hortline" colspan="2"><img src="../images/clear.gif"/></td>
    </tr>
    <tr>
        <td colspan="2" class='detailSection alignLeft'><xsl:copy-of select="$NetworkInformationLabel"/></td>
    </tr>
    <tr>
        <td colspan="2">
            <table border="0"  cellpadding="0" cellspacing="0">
            <xsl:for-each select="NetworkAdapter">
            <tr>
                <td class='detailSection alignLeft'><xsl:copy-of select="$NetworkAdapterLabel"/></td>                
                <td width="400px" style='font-size:12px; padding-left:5px'><xsl:value-of select="Adapter"/></td>
            </tr>
            <tr>                
                <td width="80px" style='padding-left:15px' class='detailSection alignLeft'><xsl:copy-of select="$NetworkDHCPLabel"/></td>
                <td width="80px" style='font-size:12px; padding-left:5px'><xsl:value-of select="DHCP"/></td>
            </tr>
            <tr>
                <td width="80px" style='padding-left:15px' class='detailSection alignLeft'><xsl:copy-of select="$NetworkIPLabel"/></td>                
                <xsl:for-each select="IPs">
                    <td style='font-size:12px; padding-left:5px'><xsl:value-of select="IP"/></td>
                </xsl:for-each>
            </tr>
            <tr>
                <td width="80px" style='padding-left:15px' class='detailSection alignLeft'><xsl:copy-of select="$NetworkMACLabel"/></td>
                <td width="80px" style='font-size:12px; padding-left:5px'><xsl:value-of select="MAC"/></td>
            </tr>

            </xsl:for-each>
            </table>
        </td>
    </tr> 
</xsl:template>

<!--
<xsl:template match="NetworkAdapters/NetworkAdapter/IPs">    
    <xsl:for-each select="IP">
       <td width="50" style='font-size:12px; padding-left:5px'><xsl:value-of select="IP"/></td>
    </xsl:for-each> 
</xsl:template>
-->

<xsl:template match="RemovableDevices">
    <tr>
        <td class="hortline" colspan="2"><img src="../images/clear.gif"/></td>
    </tr>
    <tr>
        <td colspan="2" class='detailSection alignLeft'><xsl:copy-of select="$RemovableDeviceLabel"/></td>
    </tr>
    <tr>
        <td colspan="2">
            <table border="0"  cellpadding="0" cellspacing="0">
            <tr>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$RemovableDeviceName"/></td>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$RemovableDeviceDescription"/></td>                
            </tr>
            <xsl:for-each select="RemovableDevice">
            <tr>
                <td width="285px" style='font-size:12px; padding-left:5px'><xsl:value-of select="Name"/></td>
                <td width="285px" style='font-size:12px; padding-left:5px'><xsl:value-of select="Description"/></td>                
            </tr>
            </xsl:for-each>
            </table>
        </td>
    </tr>  
</xsl:template>

<xsl:template match="Applicatons">
    <xsl:choose>
		<xsl:when test="(count(DetailsEmpty) &gt; 0) or count(ApplicationsError) &gt; 0">
					<tr>
        				<td colspan="2" class='detailSection alignLeft' style='color:gray'><xsl:copy-of select="$Applications"/></td>
    				</tr>
			        <tr>
            			<td colspan="2" style='font-size:12px; padding-left:5px; color:gray'><i><xsl:copy-of select="$AgentError"/></i></td>
					</tr>
		</xsl:when>
		<xsl:otherwise>
				<tr>
					<td class="hortline" colspan="4"><img src="../images/clear.gif"/></td>
				</tr>
				<tr>
					<td colspan="2" class='detailSection alignLeft'><xsl:copy-of select="$Applications"/></td>
				</tr>
				<tr>
					<td colspan="2">
						<table border="0"  cellpadding="0" cellspacing="0">
						<tr>
							<td class='detailSection alignLeft'><xsl:copy-of select="$ApplicationName"/></td>
							<td class='detailSection alignLeft'><xsl:copy-of select="$ApplicationVendor"/></td>
							<td class='detailSection alignLeft'><xsl:copy-of select="$ApplicationVersion"/></td>
						</tr>
						<xsl:for-each select="Application">
						<tr>
							<td style='font-size:12px; padding-left:5px'><xsl:value-of select="Name"/></td>
							<td style='font-size:12px; padding-left:5px'><xsl:value-of select="Vendor"/></td>
							<td style='font-size:12px; padding-left:5px'><xsl:value-of select="Version"/></td>
						</tr>
						</xsl:for-each>
						</table>
					</td>
				</tr>
		</xsl:otherwise>
    </xsl:choose>
</xsl:template>


<xsl:template match="MemoryPhysical">
    <tr>
        <td class="hortline" colspan="4"><img src="../images/clear.gif"/></td>
    </tr>
    <tr>
        <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$MemoryLabel"/></td>        
    </tr>       
    <tr>
        <td colspan="2">
            <table border="0" cellpadding="0" cellspacing="0" >
            <tr>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$MemoryBank"/></td>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$MemoryCapacity"/></td>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$MemoryBankLabel"/></td>
            </tr>
            <xsl:for-each select="Module">
            <tr>
                <td style='font-size:12px; padding-left:5px'><xsl:value-of select="Bank"/></td>
                <td style='font-size:12px; padding-left:5px'><xsl:value-of select="Capacity"/></td>
                <td style='font-size:12px; padding-left:5px'><xsl:value-of select="BankLabel"/></td>
            </tr>
            </xsl:for-each>
            <tr>
                <td width="285px"></td>
                <td width="285px" class='detailSection alignLeft' style='font-size:12px;' ><xsl:copy-of select="$MemoryCapacityTotal"/></td>
                <td width="285px" class='detailSection alignLeft' style='font-size:12px;' ><xsl:copy-of select="$MemoryPhysicalUse"/></td>
            </tr>    
            <tr>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$MemoryPhysicalLabel"/></td>
                <td width="285px" style='font-size:12px; padding-left:5px' ><xsl:value-of select="MemSizeTotal"/></td>
                <td width="285px" style='font-size:12px; padding-left:5px' ><xsl:value-of select="MemoryPhysicalUse"/></td>
            </tr>           
            </table>
        </td>
    </tr>
</xsl:template>

<xsl:template match="MemoryVirtual">
    <!--
    <tr>
        <td class="hortline" colspan="4"><img src="../images/clear.gif"/></td>
    </tr>
    <tr>
        <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$MemoryVirtualLabel"/></td>        
    </tr>-->
    <tr>
        <td colspan="2">
            <table border="0" cellpadding="0" cellspacing="0" >  
            <tr>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$MemoryVirtualLabel"/></td>  
                <td width="285px" style='font-size:12px; '><xsl:value-of select="MemSizeTotal"/></td>
                <td width="285px" style='font-size:12px; '><xsl:value-of select="MemoryVirtualUse"/></td>
            </tr>
            </table>
        </td>
    </tr>
</xsl:template>

<xsl:template match="PhysicalDisks">
    <tr>
        <td class="hortline" colspan="2"><img src="../images/clear.gif"/></td>
    </tr>
    <tr>
        <td colspan="1" class='detailSection alignLeft'><xsl:copy-of select="$PhysicalDisks"/></td>        
    </tr>
    <tr>
        <td colspan="2">
            <table border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$PhysicalDiskDeviceID"/></td>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$PhysicalDiskTotalSize"/></td>
                <td width="285px" class='detailSection alignLeft'><xsl:copy-of select="$PhysicalDiskInfo"/></td>
            </tr>
            <xsl:for-each select="PhysicalDisk">
            <tr>
                <td width="285px" style='font-size:12px; padding-left:5px'><xsl:value-of select="DeviceId"/></td>
                <td width="285px" style='font-size:12px; padding-left:5px'><xsl:value-of select="Capacity"/></td>
                <td width="285px" style='font-size:12px; padding-left:5px'><xsl:value-of select="DeviceInfo"/></td>
            </tr>
            </xsl:for-each>
            <tr>
                <td width="285px" style='font-size:12px; padding-left:5px'><xsl:copy-of select="$MemoryCapacityTotal"/></td>
                <td width="285px" style='font-size:12px; padding-left:5px'><xsl:value-of select="TotalPhysical"/></td>
            </tr>            
            </table>
        </td>
    </tr>
</xsl:template>

<xsl:template match="RaidControllers">
    <xsl:if test="count(RaidController) &gt; 0">
      <tr>
          <td class="hortline" colspan="2"><img src="../images/clear.gif"/></td>
      </tr>
      <tr>
          <td colspan="1" class='detailSection alignLeft'><xsl:copy-of select="$RaidLabel"/></td>        
      </tr>
      <tr>
          <td colspan="2">
              <table border="0" cellpadding="0" cellspacing="0">
              <tr>
                  <td width="90px" class='detailSection alignLeft'><xsl:copy-of select="$RaidController"/></td>
                  <!--<td width="70px" class='detailSection alignLeft'><xsl:copy-of select="$RaidSet"/></td>-->
                  <xsl:if test="count(RaidController/RaidSet) &gt; 0">
                  <td width="90px" class='detailSection alignLeft'><xsl:copy-of select="$RaidStatus"/></td>
                  <td width="90px" class='detailSection alignLeft'><xsl:copy-of select="$RaidLevel"/></td>
                  <td width="90px" class='detailSection alignLeft'><xsl:copy-of select="$RaidSize"/></td>
                  <td width="90px" class='detailSection alignLeft'><xsl:copy-of select="$RaidNumDrives"/></td>
                  </xsl:if>
              </tr>
              <xsl:for-each select="RaidController">
              <tr>
                  <td width="90px" style='font-size:12px; padding-left:5px'><xsl:value-of select="Model"/></td>
                  <!--<td width="70px" style='font-size:12px; padding-left:5px'><xsl:value-of select="Set"/></td>-->
                  <xsl:for-each select="RaidSet">
                  <td width="90px" style='font-size:12px; padding-left:5px'><xsl:value-of select="Status"/></td>
                  <td width="90px" style='font-size:12px; padding-left:5px'><xsl:value-of select="Level"/></td>
                  <td width="90px" style='font-size:12px; padding-left:5px'><xsl:value-of select="Size"/></td>
                  <td width="90px" style='font-size:12px; padding-left:5px'><xsl:value-of select="NumDrives"/></td>
                  </xsl:for-each>
              </tr>
              </xsl:for-each>
              </table>
          </td>
      </tr>
    </xsl:if>    
</xsl:template>

<xsl:template match="PCISlots">
    <tr>
        <td class="hortline" colspan="4"><img src="../images/clear.gif"/></td>
    </tr>
    <tr>
        <td colspan="2" class='detailSection alignLeft'><xsl:copy-of select="$Slots"/></td>
    </tr>
    <tr>
        <td colspan="2">
            <table border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td width="285px"  class='detailSection alignLeft'><xsl:copy-of select="$SlotName"/></td>
                <td width="285px"  class='detailSection alignLeft'><xsl:copy-of select="$SlotStatus"/></td>
            </tr>
            <xsl:for-each select="Slot">
            <tr>
                <td width="285px"  style='font-size:12px; padding-left:5px'><xsl:value-of select="SlotName"/></td>
                <td width="285px"  style='font-size:12px; padding-left:5px'><xsl:value-of select="SlotUse"/></td>
            </tr>
            </xsl:for-each>
            </table>
        </td>
    </tr>
</xsl:template>



</xsl:stylesheet>