var checkTime = 10000; //milliseconds

// timeoutInterval comes in as seconds from Jetty
// sessionLastAccessTime is milliseconds from epoch 1970
function updateSessionInfo( timeoutInterval ) {
    // only the top frame needs to pass this info once
    if( self == top ) {
        setSessionTimeoutInterval(timeoutInterval * 1000);
    }
    setSessionLastAccessTime((new Date()).valueOf());
    checkSession();

}

function checkSession() {
    top.checkSessionIntervalId = setInterval('validateLastAccessTime()', checkTime);
}

function setSessionExpiredMessage( msg ) {
    top.sessionExpiredMessage = msg;
}

function getSessionExpiredMessage() {
    return top.sessionExpiredMessage;
}

function validateLastAccessTime() {
    var sessionCurrentTime = (new Date()).valueOf();
    if( (sessionCurrentTime - top.sessionLastAccessTime) >= getSessionTimeoutInterval() ) {
        top.disableAllFormButtons();
        stopCheckSessionInterval();
        top.doLogout();
        if( document.all){
            top.frames['content'].alert(getSessionExpiredMessage());
        }
    }
}

function stopCheckSessionInterval() {
    if( top.checkSessionIntervalId ) {
        clearInterval(top.checkSessionIntervalId);
    }
}

function setSessionTimeoutInterval( interval ) {
    top.sessionTimeoutInterval = interval;
}

function getSessionTimeoutInterval() {
    return top.sessionTimeoutInterval;
}

function getSessionLastAccessTime() {
    return top.sessionLastAccessTime;
}

function setSessionLastAccessTime( time ) {
    top.sessionLastAccessTime = time;
}

function disableAllFormButtons() {
    var frameCount = top.frames.length;
    for( var i=0; i<frameCount; i++ ) {
        //alert(top.frames[i].name);
        disableFormButtons(top.frames[i]);
    }
}

function disableFormButtons( targetWindow ) {
    var doc = targetWindow.document;
   // Loop through all the forms on the pages
    var f = 0;
    for( var f=0; f<doc.forms.length; f++ ) {
        // Loop through all the elements in the form
        for( var e=0; e<doc.forms[f].elements.length; e++ ) {
            var ele = doc.forms[f].elements[e];
            if( ele.type == 'button' || ele.type == 'submit' ) {
                //alert(ele.name);
                ele.disabled = true;
            }
         }
    }
}

function doLogout() {
    top.window.location = getAppRoot() + "/logout.jsp";
}